;;  Programm:      ACM-UNSICHTBAR.LSP
;;  Befehlsaufruf: ACM-UNSICHTBAR
;;  Funktion:      Macht Objekte temporr unsichtbar.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         15.09.2025
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2014
(defun c:acm-unsichtbar ( / unv10 unv51 unv52 unv47 uvn01 uvn02 uvn03 uvn04 uvn05 uvn06 uvn07 uvn08 uvn09 uvn10 uvn11 uvn12)
(defun uvn01 ( / unv09 unv10 unv11 unv12 unv13 unv14 unv15 unv16 unv17 unv18 unv19)
(if (= (getvar "TILEMODE") 1)
(progn
(setq unv09 (vlax-get-acad-object))
(setq unv10 (vlax-get unv09 'ActiveDocument))
(setq unv11 (vlax-get unv10 'ActiveViewport))
(setq unv12 (vlax-get unv11 'Name))
(setq unv13 (tblobjname "VPORT" unv12))
(setq unv14 (entget unv13))
(setq unv15 (assoc 348 unv14))
(setq unv16 (cdr unv15))
(setq unv17 (entget unv16))
(setq unv18 (cdr (assoc 2 unv17)))
(if (= (strcase unv18) "2DWIREFRAME")
(setq unv19 1)
(setq unv19 0)))
(setq unv19 0))
unv19)
(defun uvn02 (unv01 / )
(if unv51 (setq *error* unv51))
(if unv23
(vl-catch-all-apply 'setvar (list "CMDECHO" unv23)))
(if unv21
(vl-catch-all-apply 'setvar (list "PICKBOX" unv21)))
(vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
(princ))
(defun uvn03 ( / unv20 unv19)
(setq unv20 (strcase (getvar "PRODUCT")))
(if (/= unv20 "AUTOCAD")
(progn
(setq unv19 0)
(alert "\042acm-unsichtbar\042 kann nur unter AutoCAD verwendet werden.")))
(if
(and
(= unv20 "AUTOCAD")
(not (getvar "SECURELOAD")))
(progn
(setq unv19 0)
(alert "\042acm-unsichtbar\042 kann nur unter AutoCAD ab Version 2014 verwendet werden.")))
(if
(and
(= unv20 "AUTOCAD")
(getvar "SECURELOAD")
(= (getvar "TILEMODE") 0))
(progn
(setq unv19 0)
(alert "\042acm-unsichtbar\042 kann nur im Modellbereich verwendet werden.")))
(if
(and
(= unv20 "AUTOCAD")
(getvar "SECURELOAD")
(= (getvar "TILEMODE") 1)
(= (uvn01) 0))
(progn
(setq unv19 0)
(alert "\042acm-unsichtbar\042 kann nur im visuellen Stil \0422D-Drahtkrper\042 verwendet werden.")))
(if
(and
(= unv20 "AUTOCAD")
(getvar "SECURELOAD")
(= (getvar "TILEMODE") 1)
(= (uvn01) 1))
(setq unv19 1))
unv19)
(defun uvn04 (unv02 / unv21 unv22)
(sssetfirst nil nil)
(setq unv21 (getvar "PICKBOX"))
(initget "Einstellungen Beenden")
(setq unv22 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen/Beenden]: "))
(while (= unv22 "Einstellungen")
(uvn09 unv21)
(initget "Einstellungen Beenden")
(setq unv22 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen/Beenden]: ")))
(if (/= unv22 "Beenden")
(progn
(if (= mej62&_kl352-$xx27gtzub 1)
(setvar "PICKBOX" mej62&_kl352-$xx27gtzuc))
(uvn05 mej62&_kl352-$xx27gtzud mej62&_kl352-$xx27gtzue unv02)
(if unv21
(setvar "PICKBOX" unv21)))))
(defun uvn05 (unv03 unv04 unv05 / unv23 unv24 unv25)
(setq unv23 (getvar "CMDECHO"))
(setvar "CMDECHO" 0)
(setq unv24 (getvar "ERRNO"))
(setvar "ERRNO" 0)
(if (> unv04 0)
(progn
(while (vl-position (getvar "ERRNO") (list 0))
(setq unv25 (ssget "_:S"))
(if unv25
(uvn12 unv25 unv03))))
(progn
(while (vl-position (getvar "ERRNO") (list 0))
(setq unv25 (ssget "_:S"))
(if unv25
(progn
(uvn12 unv25 unv03)
(setvar "ERRNO" 1))))))
(setvar "ERRNO" unv24)
(setvar "CMDECHO" unv23))
(defun uvn06 ( / unv26 unv27 unv35)
(if
(and
unv52
(= mej62&_kl352-$xx27gtzud 1))
(progn
(if (> mej62&_kl352-$xx27gtzua 0)
(prompt "\nACHTUNG: Aktuell werden auch gesperrte Objekte unsichtbar gemacht. ")
(progn
(if (setq unv26 (uvn07))
(progn
(setq unv27 (load_dialog unv26))
(if (not (new_dialog "acm_alert" unv27))
(exit))
(vl-catch-all-apply 'vl-file-delete (list unv26))
(action_tile "b_01" "(setq mej62&_kl352-$xx27gtzua (atoi (get_tile \"tg_01\"))) (done_dialog)")
(start_dialog)
(unload_dialog unv27))))))))
(defun uvn07 ( / unv31 unv29 unv30)
(if
(and
(setq unv29 (vl-filename-mktemp "acm.dcl"))
(setq unv30 (open unv29 "w")))
(progn
(setq unv31
(list
"acm_alert"
":dialog{label=\042ACHTUNG\042;"
":spacer{height=0.2;}"
":text{value=\042Aktuell werden auch gesperrte\042;}"
":text{value=\042Objekte unsichtbar gemacht.\042;}"
":spacer{height=0.3;}"
":row{"
":spacer{width=0;}"
":column{width=10;fixed_width=true;"
":button{key=\042b_01\042;label=\042OK\042;is_default=true;}}"
":spacer{width=0;}}"
":toggle{key=\042tg_01\042;label=\042&Nicht mehr anzeigen\042;}}"))
(while unv31
(write-line (car unv31) unv30)
(setq unv31 (cdr unv31)))
(setq unv30 (close unv30))
unv29)
nil))
(defun uvn08 ( / unv32 unv53 unv33 unv34)
(setq unv32 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
(vlax-for unv53 unv32
(if
(and
(not (vl-string-search "|" (setq unv33 (strcase (vla-get-Name unv53)))))
(= (vla-get-Lock unv53) :vlax-true))
(setq unv34 (cons unv33 unv34))))
unv34)
(defun uvn09 (unv06 / unv26 unv27 unv35 unv38)
(if (setq unv26 (uvn10))
(progn
(setq unv27 (load_dialog unv26))
(if (not (new_dialog "acm_sbe" unv27))
(exit))
(vl-catch-all-apply 'vl-file-delete (list unv26))
(start_list "pl_01")
(mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
(end_list)
(set_tile "tg_01" (itoa mej62&_kl352-$xx27gtzud))
(set_tile "tg_02" (itoa mej62&_kl352-$xx27gtzue))
(if (= mej62&_kl352-$xx27gtzub 0)
(set_tile "pl_01" "0")
(set_tile "pl_01" (itoa mej62&_kl352-$xx27gtzuc)))
(action_tile "b_01" "(setq unv35 (atoi (get_tile \"pl_01\")))
(if (= unv35 0)
(progn
(setq mej62&_kl352-$xx27gtzub 0)
(setq mej62&_kl352-$xx27gtzuc (getvar \"PICKBOX\")))
(progn
(setq mej62&_kl352-$xx27gtzub 1)
(setq mej62&_kl352-$xx27gtzuc unv35)))
(setq unv38 (list (setq mej62&_kl352-$xx27gtzud (atoi (get_tile \"tg_01\"))) (setq mej62&_kl352-$xx27gtzue (atoi (get_tile \"tg_02\"))) mej62&_kl352-$xx27gtzub mej62&_kl352-$xx27gtzuc))
(done_dialog)
(uvn11 unv06)")
(action_tile "b_02" "(setq unv38 nil) (done_dialog)")
(start_dialog)
(unload_dialog unv27)))
unv38)
(defun uvn10 ( / unv31 unv29 unv30)
(if
(and
(setq unv29 (vl-filename-mktemp "acm.dcl"))
(setq unv30 (open unv29 "w")))
(progn
(setq unv31
(list
"acm_sbe"
":dialog{label=\042Einstellungen\042;"
":spacer{height=0.2;}"
":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
":spacer{height=0.6;}"
":toggle{key=\042tg_01\042;label=\042&Layersperrung ignorieren\042;}"
":toggle{key=\042tg_02\042;label=\042&Wiederholmodus ein\042;}"
":spacer{height=0.3;}"
":row{"
":spacer{width=0;}"
":column{width=0;fixed_width=true;"
":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
":spacer{width=0;}}}"))
(while unv31
(write-line (car unv31) unv30)
(setq unv31 (cdr unv31)))
(setq unv30 (close unv30))
unv29)
nil))
(defun uvn11 (unv06 / unv41 unv42 unv43)
(if (not (vl-position mej62&_kl352-$xx27gtzub (list 0 1)))
(setq mej62&_kl352-$xx27gtzub 0))
(if (not (vl-position mej62&_kl352-$xx27gtzuc (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
(progn
(setq mej62&_kl352-$xx27gtzub 0)
(setq mej62&_kl352-$xx27gtzuc (getvar "PICKBOX"))))
(if (not (vl-position mej62&_kl352-$xx27gtzud (list 0 1)))
(setq mej62&_kl352-$xx27gtzud 0))
(if (not (vl-position mej62&_kl352-$xx27gtzue (list 0 1)))
(setq mej62&_kl352-$xx27gtzue 1))
(if (not (vl-position mej62&_kl352-$xx27gtzua (list 0 1)))
(setq mej62&_kl352-$xx27gtzua 0))
(if (= mej62&_kl352-$xx27gtzub 0)
(setq unv41 (strcat "\nAkt. Einstellungen: Pickbox-Gre = Aktuell (" (itoa unv06) "),"))
(setq unv41 (strcat "\nAkt. Einstellungen: Pickbox-Gre = Befehlsabhngig (" (itoa mej62&_kl352-$xx27gtzuc) "),")))
(setq unv42 (strcat " Layersperrung ignorieren = " (nth mej62&_kl352-$xx27gtzud (list "Nein," "Ja,"))))
(setq unv43 (strcat " Wiederholmodus ein = " (nth mej62&_kl352-$xx27gtzue (list "Nein" "Ja")) " "))
(prompt (strcat unv41 unv42 unv43)))
(defun uvn12 (unv07 unv08 / unv44 unv45 unv46 unv48 unv49 unv50)
(setq unv44 (sslength unv07))
(setq unv45 -1)
(repeat unv44
(setq unv45 (1+ unv45))
(setq unv46 (ssname unv07 unv45))
(if (= unv08 1)
(progn
(redraw unv46 2)
(setq unv47 (1+ unv47)))
(progn
(setq unv48 (vlax-ename->vla-object unv46))
(setq unv49 (vlax-get unv48 'Layer))
(setq unv50 (vlax-ename->vla-object (tblobjname "LAYER" unv49)))
(if (= (vla-get-Lock unv50) :vlax-false)
(progn
(redraw unv46 2)
(setq unv47 (1+ unv47))))))))
(if (= (uvn03) 1)
(progn
(vl-load-com)
(setq unv10 (vla-get-ActiveDocument (vlax-get-acad-object)))
(setq unv51 *error*)
(setq *error* uvn02)
(vla-EndUndoMark unv10)
(vla-StartUndoMark unv10)
(uvn11 (getvar "PICKBOX"))
(setq unv52 (uvn08))
(uvn06)
(setq unv47 0)
(uvn04 unv52)
(if unv51
(setq *error* unv51)
(setq *error* nil))
(vla-EndUndoMark unv10)
(if (= unv47 0)
(prompt "\n0 Objekte wurden unsichtbar gemacht. ")
(progn
(if (= unv47 1)
(prompt (strcat "\n" (itoa unv47) " Objekt wurde unsichtbar gemacht. Benutzen Sie den Befehl REGEN, um das Objekt wieder sichtbar zu machen. "))
(prompt (strcat "\n" (itoa unv47) " Objekte wurden unsichtbar gemacht. Benutzen Sie den Befehl REGEN, um die Objekte wieder sichtbar zu machen. ")))))))
(princ))
(terpri)
(princ (strcat "\nAutoLISP-Tool ACM-UNSICHTBAR (Copyright  " (substr (rtos (getvar "CDATE")) 1 4) " Gerhard Rampf) geladen. "))
(princ "\nRufen Sie den Befehl mit ACM-UNSICHTBAR auf.")
